extends CanvasLayer
class_name LevelWin

# this class controls the level complete (success) scene 
# fill the data about finishing a level e.g ( score , progress )

const WinTitles  : Dictionary = {
	0 : "a w e s o m e !",
	1 : "g r e a t !",
	2 : "a m a z i n g !",
}

onready var _title : Label = get_node("tint/main/title/title_bg/lbl_title")
onready var _earnings :  Label = get_node(
	"tint/main/reward/vbox/reward_bg/bg_panel/icon_count/count/nbr")
onready var _earnings_icon : TextureRect = get_node(
	"tint/main/reward/vbox/reward_bg/bg_panel/icon_count/icon/collectable_icon")
onready var _reward_icon : TextureRect = get_node(
	"tint/main/double_reward/center/btn_rewarded_double/btn_lbl/icon/collectable_icon")
onready var _animation_tree : AnimationTree = get_node("AnimationTree")
onready var _animation : AnimationPlayer = get_node("AnimationPlayer")
onready var _rewarded_btn : Button = get_node(
	"tint/main/double_reward/center/btn_rewarded_double")
onready var _double_reward_prize : Label = get_node(
	"tint/main/double_reward/center/reward_prize")
onready var _timer : Timer = get_node_or_null("Timer")
onready var _go_next_anim : AnimationPlayer = get_node_or_null(
	"tint/main/next_retry/hbox/next/btn_continue/guide/AnimationPlayer")

func _ready():
	_animation.stop()
	B4DFramework.b4d_ads.connect("rewarded",self,"_reward")
	B4DFramework.b4d_ads.connect("interstitial_closed",self,"_interstitial_closed")
	_set_ads_depend_ui()


func init(earnings : int , coin_icon : Texture) -> void:
	_earnings.text = str(earnings)
	_earnings_icon.texture = coin_icon
	_reward_icon.texture = coin_icon
	_change_title()
	_show_ui()


func _change_title():
	_title.text = WinTitles[randi() % 3]


func _set_ads_depend_ui():
	if not B4DFramework.is_ads_active:
		var reward_btn_ui : Control = get_node(
			"tint/main/double_reward/center/btn_rewarded_double/btn_lbl")
		var video_icon : Control = get_node(
			"tint/main/double_reward/center/btn_rewarded_double/video_icon")
		var lvl_next_lbl : Control = get_node(
			"tint/main/double_reward/center/btn_rewarded_double/lvl_action_lbl")
		var footer_next : Control = get_node("tint/main/next_retry/hbox/next")
		
		## Hide show ads depend UI
		reward_btn_ui.visible = false
		video_icon.visible = false
		footer_next.visible = false
		
		lvl_next_lbl.visible = true


func _show_ui() -> void:
	UserData.update_score(B4DFramework.get_coins_count() + int(_earnings.text),
	B4DFramework.get_level())
#	_animation_tree.active = true
#	_animation_tree.set("parameters/OneShot/active",true)
	_animation.play("level_win_appear")
	_animation.queue("btn_x2reward_bounce")
	


func _on_retry_pressed() -> void:
	Sounds.play_tap_sound()
	if B4DFramework.b4d_ads.get_is_interstitial_loaded():
		B4DFramework.b4d_ads.show_interstitial()
	else:
		print(B4DFramework.get_level())
		B4DFramework.set_level(B4DFramework.get_level() - 1)
		print(B4DFramework.get_level())
		_interstitial_closed()


func _on_continue_pressed() -> void:
	Sounds.play_tap_sound()
	if B4DFramework.b4d_ads.get_is_interstitial_loaded():
		B4DFramework.b4d_ads.show_interstitial()
	else:
		_interstitial_closed()


func _on_btn_rewarded_pressed():
	Sounds.play_tap_sound()
	if B4DFramework.is_ads_active:
		Utils.debug("_on_btn_rewarded_pressed",0,str(B4DFramework.b4d_ads.is_rewarded_video_loaded()))
		if B4DFramework.b4d_ads.is_rewarded_video_loaded():
			B4DFramework.b4d_ads.show_rewarded_video()
		else:
			B4DFramework.pop_notif.show()
			B4DFramework.b4d_ads.load_rewarded_video()
	else :
		_interstitial_closed()


func _reward(currency , amount) -> void:
	_double_reward()


func _interstitial_closed() -> void:
	get_tree().reload_current_scene()


func _double_reward() -> void:
	var prize := int(_earnings.text) * 2
	_double_reward_prize.text = "+ " + str(prize)
	
	UserData.update_score(B4DFramework.get_coins_count() + prize,
	B4DFramework.get_level())
	_animation.play("double_rewarded_prize")
	

func _on_timer_timeout():
	_go_next_anim.play("go_next_guide")
